# バッチ設計書 2-CronJob Controller

## 概要

本ドキュメントは、Cron形式のスケジュールに基づいてJobを定期的に作成・管理するCronJob Controllerの設計を記述する。CronJob ControllerはDelayingQueueとInformerを使用するV2実装であり、kube-controller-manager内で動作する。

### 本バッチの処理概要

CronJob Controllerは、CronJobリソースの定義に基づいて定期的にJobリソースを作成し、そのライフサイクルを管理するコントローラーである。

**業務上の目的・背景**：定期的なバッチ処理（日次集計、ログローテーション、バックアップ等）をKubernetes上で実現するため、cron形式のスケジュールでJobを自動生成する仕組みが必要である。CronJob Controllerは、ユーザーがCronJobリソースとしてスケジュールとJobテンプレートを定義するだけで、時間ベースの自動ジョブ実行を実現する。

**バッチの実行タイミング**：CronJobリソースの作成・更新・削除イベント、およびJobの状態変更イベントをInformerで監視し、イベント駆動で随時実行される。次回スケジュール時刻にDelayingQueueを使用してリキューされる。

**主要な処理内容**：
1. CronJobリソースの監視（Informer経由でAdd/Update/Deleteイベント）
2. Cronスケジュール解析とタイムゾーン対応
3. 同時実行ポリシー制御（Allow/Forbid/Replace）
4. Jobリソースの作成（CronJob.spec.jobTemplateから生成）
5. 完了済みJob履歴の管理（SuccessfulJobsHistoryLimit/FailedJobsHistoryLimit）
6. 開始デッドライン制御（StartingDeadlineSeconds）
7. CronJobステータスの更新（LastScheduleTime, LastSuccessfulTime）

**前後の処理との関連**：CronJob Controllerが作成したJobは、Job Controllerが管理する。OwnerReferenceによりCronJob→Jobの親子関係が設定される。

**影響範囲**：CronJobリソース、Jobリソース、Eventリソース。NamespaceスコープでのAPI Server操作。

## バッチ種別

コントローラーループ型（スケジュール駆動バッチ処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 + スケジュール駆動 |
| 実行時刻 | CronJobのspec.scheduleに基づく |
| 実行曜日 | Cron式により指定 |
| 実行日 | Cron式により指定 |
| トリガー | CronJob/Jobリソースイベント、DelayingQueueによる次回スケジュール |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | CronJob Controllerはkube-controller-manager内で起動する |
| Informerキャッシュ同期完了 | JobとCronJobのInformerキャッシュが同期済みであること |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

Informerキャッシュの同期（cache.WaitForNamedCacheSyncWithContext）が完了した場合にワーカーを起動する。CronJobがSuspend状態の場合はJob作成をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| workers | int | Yes | なし | syncワーカーの並列数 |
| nextScheduleDelta | time.Duration | No | 100ms | 次回スケジュール算出のデルタ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CronJob Informer | Kubernetes API (batch/v1 CronJob) | CronJobリソースの変更イベントを監視 |
| Job Informer | Kubernetes API (batch/v1 Job) | Jobリソースの変更イベントを監視 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Job | Kubernetes API (batch/v1 Job) | CronJob仕様に基づくJob作成 |
| CronJob Status | Kubernetes API (batch/v1 CronJob) | LastScheduleTime, LastSuccessfulTime等の更新 |
| Event | Kubernetes API (core/v1 Event) | CronJob関連イベントの記録 |

### 出力ファイル仕様

ファイル出力はなし。全てKubernetes API Server経由のリソース操作。

## 処理フロー

### 処理シーケンス

```
1. コントローラー初期化（NewControllerV2）
   └─ Informer登録、workqueue作成、jobControl/cronJobControl初期化
2. Run起動
   └─ EventBroadcaster開始、キャッシュ同期待ち、ワーカーgoroutine起動
3. ワーカーループ（worker）
   └─ キューからキーを取得し、sync実行
4. sync処理
   ├─ CronJob取得
   ├─ 関連Job一覧取得（getJobsToBeReconciled）
   ├─ 完了済みJob削除（cleanupFinishedJobs）
   ├─ syncCronJob（スケジュール判定・Job作成）
   └─ CronJobステータス更新
5. リキュー
   └─ 次回スケジュール時刻にDelayingQueueへ再投入
```

### フローチャート

```mermaid
flowchart TD
    A[コントローラー起動] --> B[Informerキャッシュ同期]
    B --> C{同期完了?}
    C -->|Yes| D[ワーカー起動]
    C -->|No| E[コントローラー終了]
    D --> F[キューからCronJobキー取得]
    F --> G[CronJob/Job取得]
    G --> H[完了済みJob削除]
    H --> I{スケジュール到達?}
    I -->|Yes| J{同時実行ポリシーチェック}
    I -->|No| K[次回スケジュールでリキュー]
    J -->|Allow| L[Job作成]
    J -->|Forbid/Replace| M[既存Job確認後処理]
    L --> N[ステータス更新]
    M --> N
    N --> K
    K --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Job作成 | etcd (jobs) | CREATE | CronJobテンプレートからJob生成 |
| Job削除 | etcd (jobs) | DELETE | 履歴超過Jobの削除 |
| CronJob Status更新 | etcd (cronjobs) | UPDATE | LastScheduleTime等の更新 |
| Event記録 | etcd (events) | CREATE | CronJob関連イベント |

### テーブル別操作詳細

#### CronJob (batch/v1)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status.lastScheduleTime | 最後のスケジュール時刻 | Job作成成功時 |
| UPDATE | status.lastSuccessfulTime | 最後の成功時刻 | Job成功時 |
| UPDATE | status.active | アクティブJob参照リスト | Job作成/完了時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CronJob NotFound | CronJobが削除済み | 処理スキップ（nilを返却） |
| - | API Server通信エラー | API Server到達不能 | レートリミット付きリキュー |
| - | スケジュール解析エラー | 不正なCron式 | イベント記録、リキューなし |
| - | Job作成失敗 | リソース制限等 | エラーリターン、リキュー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | TypedRateLimitingQueue（指数バックオフ） |
| リトライ対象エラー | API Server通信エラー、ステータス更新エラー |

### 障害時対応

コントローラー再起動時にInformerキャッシュ再同期により全CronJobを再評価する。StartingDeadlineSecondsによりスケジュールミスの許容範囲を制御する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | CronJob単位（1 syncコール = 1 CronJob） |
| コミットタイミング | Job操作後にステータス更新 |
| ロールバック条件 | ステータス更新失敗時はリキューで再試行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | クラスタ内CronJob数に依存 |
| 目標処理時間 | ワーカーループ間隔 = 1秒 |
| メモリ使用量上限 | Informerキャッシュサイズに依存 |

## 排他制御

- workqueueによるキー単位の排他制御（同一CronJobキーは同時に1ワーカーのみ処理）
- ConcurrencyPolicy（Allow/Forbid/Replace）によるJob並行実行の制御
- API Serverの楽観的並行性制御（ResourceVersion）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting cronjob controller v2" |
| 進捗ログ | sync実行時（V2/V4） | CronJobのリコンシル詳細、リキュー情報 |
| 終了ログ | コントローラー停止時 | "Shutting down cronjob controller v2" |
| エラーログ | エラー発生時 | sync失敗、ステータス更新失敗 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| cronjob_controller_rate_limiter_use | メトリクス（Prometheusで監視） | クラスタ管理者 |
| workqueue深さ | メトリクス（Prometheusで監視） | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/cronjob/cronjob_controllerv2.go`
- V2実装: DelayingQueueとInformerを使用するリファクタリング版
- controllerKind: `batch/v1 CronJob`
- スケジュール解析: `k8s.io/kubernetes/pkg/util/parsers.ParseCronScheduleWithPanicRecovery`
